<?php
include 'includes/header.php';

// Fetch Sliders
$sliders = $pdo->query("SELECT * FROM slider_images ORDER BY sort_order ASC")->fetchAll();

// Fetch Products
$products = $pdo->query("SELECT * FROM products ORDER BY id DESC")->fetchAll();
?>

<style>
    /* --- DESKTOP / DEFAULT STYLES --- */
    
    .product-card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        overflow: hidden;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        background: #fff;
        height: 100%;
        display: flex;
        flex-direction: column;
    }
    
    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(0,0,0,0.1);
    }

    .product-img-wrapper {
        background-color: #fff;
        padding: 25px;
        position: relative;
        height: 280px; /* Desktop Height */
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .product-img-wrapper img {
        max-height: 100%;
        max-width: 100%;
        object-fit: contain;
        transition: transform 0.3s ease;
    }

    .product-card:hover .product-img-wrapper img {
        transform: scale(1.05);
    }
    
    .card-body-custom {
        padding: 20px;
        text-align: center;
        flex-grow: 1;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }
    
    .card-title {
        font-weight: 700;
        font-size: 1.1rem; /* Desktop Font */
        margin-bottom: 5px;
        color: #2c3e50;
        line-height: 1.2;
    }

    .card-desc {
        font-size: 0.85rem;
        color: #95a5a6;
        margin-bottom: 15px;
    }
    
    .price-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
        border-top: 1px solid #f0f0f0;
        padding-top: 15px;
        margin-top: auto;
        flex-wrap: wrap; /* Allows stacking on very small screens */
        gap: 5px;
    }

    .price-tag {
        font-size: 1.3rem; /* Desktop Price */
        font-weight: 800;
        color: #2c3e50;
    }
    
    .btn-add-cart-custom {
        background: transparent;
        color: #2c3e50;
        border: 2px solid #2c3e50;
        padding: 6px 14px;
        border-radius: 6px;
        font-size: 0.75rem;
        font-weight: 700;
        text-transform: uppercase;
        transition: all 0.2s;
        white-space: nowrap; /* Prevents button text wrapping */
    }

    .btn-add-cart-custom:hover {
        background: #2c3e50;
        color: #fff;
    }

    /* Slider Desktop Height */
    .hero-slider-img {
        height: 500px;
        object-fit: cover;
    }

    /* --- MOBILE OPTIMIZATION (Max Width 768px) --- */
    @media (max-width: 768px) {
        /* Reduce Slider Height */
        .hero-slider-img {
            height: 220px; /* Much shorter for mobile */
        }
        
        /* Compact Product Image */
        .product-img-wrapper {
            height: 140px; /* Reduced height */
            padding: 10px; /* Less padding */
        }
        
        /* Compact Card Body */
        .card-body-custom {
            padding: 10px;
        }

        /* Smaller Fonts */
        .card-title {
            font-size: 0.85rem; /* Small but readable */
            height: 2.4em; /* Limit to roughly 2 lines */
            overflow: hidden;
        }

        .card-desc {
            display: none; /* Hide description on mobile to save space */
        }

        .price-row {
            padding-top: 8px;
            justify-content: center; /* Center align items on mobile */
            flex-direction: column; /* Stack Price and Button */
        }

        .price-tag {
            font-size: 1rem;
            margin-bottom: 5px;
        }

        .btn-add-cart-custom {
            width: 100%; /* Full width button on mobile */
            font-size: 0.7rem;
            padding: 5px;
        }
        
        /* Make headings smaller */
        h3.text-center {
            font-size: 1.5rem;
            margin-bottom: 1.5rem !important;
        }
    }
</style>

<?php if (!empty($sliders)): ?>
<div id="heroCarousel" class="carousel slide" data-bs-ride="carousel">
  <div class="carousel-inner">
    <?php foreach($sliders as $index => $s): ?>
    <div class="carousel-item <?= $index === 0 ? 'active' : '' ?>">
      <img src="../../<?= $s['image_path'] ?>" class="d-block w-100 hero-slider-img" alt="<?= htmlspecialchars($s['title']) ?>">
      
      <div class="carousel-caption d-none d-md-block" style="background: rgba(0,0,0,0.4); padding: 20px;">
        <?php if($s['title']): ?><h1><?= htmlspecialchars($s['title']) ?></h1><?php endif; ?>
        <?php if($s['subtitle']): ?><p class="lead"><?= htmlspecialchars($s['subtitle']) ?></p><?php endif; ?>
        <?php if($s['link'] && $s['link'] != '#'): ?>
            <a href="<?= $s['link'] ?>" class="btn btn-light mt-2">Shop Now</a>
        <?php endif; ?>
      </div>
    </div>
    <?php endforeach; ?>
  </div>
  <?php if(count($sliders) > 1): ?>
  <button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
    <span class="carousel-control-prev-icon"></span>
  </button>
  <button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
    <span class="carousel-control-next-icon"></span>
  </button>
  <?php endif; ?>
</div>
<?php endif; ?>

<div class="container my-5">
    <h3 class="mb-5 text-center text-uppercase fw-bold" style="letter-spacing: 2px; color: #333;">New Arrivals</h3>
    
    <div class="row row-cols-2 row-cols-md-3 row-cols-lg-4 g-2 g-md-4">
        <?php foreach($products as $p): ?>
        <div class="col">
            <div class="product-card">
                <a href="product_detail.php?id=<?= $p['id'] ?>" class="text-decoration-none">
                    <div class="product-img-wrapper">
                        <img src="../../<?= $p['image'] ?>" alt="<?= htmlspecialchars($p['name']) ?>">
                    </div>
                </a>
                
                <div class="card-body-custom">
                    <a href="product_detail.php?id=<?= $p['id'] ?>" class="text-decoration-none">
                        <h6 class="card-title"><?= htmlspecialchars($p['name']) ?></h6>
                        <p class="card-desc text-truncate">
                            Premium quality
                        </p>
                    </a>

                    <div class="price-row">
                        <div class="price-tag">$<?= number_format($p['price'], 2) ?></div>
                        
                        <form action="cart.php" method="POST" class="w-100 w-md-auto">
                            <input type="hidden" name="product_id" value="<?= $p['id'] ?>">
                            <input type="hidden" name="action" value="add">
                            <button type="submit" class="btn-add-cart-custom">ADD TO CART</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php 
require_once __DIR__ . '/includes/footer.php'; 
?>