<?php
// product/includes/header.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Adjust path to config/db.php based on folder structure
require_once __DIR__ . '/../../config/db.php';

// Fetch Settings
$settings = $pdo->query("SELECT * FROM company_settings WHERE id = 1")->fetch();
$bg_color = $settings['header_bg_color'] ?? '#2d2d2d';
$company_name = $settings['company_name'] ?? 'My Shop';
$logo = $settings['logo_path'] ?? '';

// Cart Count
$cart_count = 0;
if (isset($_SESSION['cart'])) {
    foreach ($_SESSION['cart'] as $qty) {
        $cart_count += $qty;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($company_name) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; background-color: #fff; }
        
        /* Navbar Base Styles */
        .navbar { 
            background-color: <?= $bg_color ?>; 
            padding: 15px 0; 
            position: relative; /* Essential for absolute centering of brand */
        }

        /* Sidebar Toggler Button */
        .sidebar-toggler {
            border: none;
            background: transparent;
            color: #fff;
            font-size: 1.5rem;
            padding: 5px;
            cursor: pointer;
            transition: color 0.3s;
        }
        .sidebar-toggler:hover { color: #ddd; }

        /* Centered Brand Name */
        .navbar-brand-centered {
            position: absolute;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            text-align: center;
            white-space: nowrap;
            z-index: 10;
        }

        .navbar-brand { 
            color: #fff; 
            font-weight: 800; 
            font-size: 24px; 
            letter-spacing: 1px; 
            text-transform: uppercase; 
            text-decoration: none;
        }
        .navbar-brand:hover { color: #ddd; }

        /* Mobile Adjustments for Brand */
        @media (max-width: 768px) {
            .navbar-brand { font-size: 18px; }
            .navbar-brand img { height: 30px; }
        }

        /* Right Side Icons */
        .nav-icon { 
            color: white; 
            font-size: 20px; 
            margin-left: 20px; 
            text-decoration: none; 
            position: relative; 
        }
        .nav-icon:hover { color: #ddd; }
        
        .cart-badge { 
            position: absolute; 
            top: -8px; 
            right: -8px; 
            background: #01e675; 
            color: #000; 
            font-size: 10px; 
            font-weight: bold; 
            border-radius: 50%; 
            padding: 3px 6px; 
        }

        /* Sidebar (Offcanvas) Styles */
        .offcanvas {
            background-color: <?= $bg_color ?>; /* Sidebar matches header color */
            color: #fff;
            max-width: 80%; /* Don't cover full screen on mobile */
            width: 300px;
        }
        
        .offcanvas-header .btn-close {
            filter: invert(1); /* White close button */
        }
        
        .offcanvas-title {
            font-weight: 800;
            letter-spacing: 1px;
            text-transform: uppercase;
        }

        .sidebar-link {
            display: block;
            padding: 15px 20px;
            color: rgba(255,255,255,0.9);
            text-decoration: none;
            font-size: 1.1rem;
            text-transform: uppercase;
            font-weight: 600;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            transition: all 0.3s;
        }

        .sidebar-link:hover {
            background-color: rgba(255,255,255,0.1);
            color: #fff;
            padding-left: 25px; /* Slide effect */
        }
        
        /* Product Card Styles (kept from your original code) */
        .product-card { border: none; transition: transform 0.2s; }
        .product-card:hover { transform: translateY(-5px); }
        .product-img-wrapper { position: relative; overflow: hidden; padding-top: 133%; background: #f8f8f8; }
        .product-img-wrapper img { position: absolute; top: 0; left: 0; width: 100%; height: 100%; object-fit: cover; }
        .price { font-weight: bold; font-size: 1.1rem; }
        .add-btn { width: 100%; background-color: #008848; color: white; font-weight: bold; border: none; padding: 10px; text-transform: uppercase; margin-top: 10px; }
        .add-btn:hover { background-color: #006636; }

    </style>
</head>
<body>

<nav class="navbar">
    <div class="container-fluid px-3 px-lg-4">
        
        <!-- 1. LEFT: Sidebar Toggle Button -->
        <div class="d-flex align-items-center">
            <button class="sidebar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebarMenu" aria-controls="sidebarMenu">
                <i class="fas fa-bars"></i>
            </button>
        </div>

        <!-- 2. CENTER: Brand Name (Absolutely Positioned) -->
        <div class="navbar-brand-centered">
            <a class="navbar-brand" href="index.php">
                <?php if($logo && file_exists('../../' . $logo)): ?>
                    <img src="../../<?= $logo ?>" alt="<?= htmlspecialchars($company_name) ?>" height="40">
                <?php else: ?>
                    <?= htmlspecialchars($company_name) ?>
                <?php endif; ?>
            </a>
        </div>
    
        <!-- 3. RIGHT: Action Icons -->
        <div class="d-flex align-items-center ms-auto">
            <!-- Search Icon -->
            <a href="search.php" class="nav-icon" title="Search">
                <i class="fas fa-search"></i>
            </a>

            <!-- Login / User Icon -->
            <?php if(isset($_SESSION['user_id'])): ?>
                <a href="../login/logout.php" class="nav-icon" title="Logout">
                    <i class="fas fa-sign-out-alt"></i>
                </a>
            <?php else: ?>
                <a href="../login/login.php" class="nav-icon" title="Login">
                    <i class="fas fa-user"></i>
                </a>
            <?php endif; ?>

            <!-- Cart Icon -->
            <a href="cart.php" class="nav-icon cart-icon" title="Cart">
                <i class="fas fa-shopping-bag"></i>
                <?php if($cart_count > 0): ?>
                    <span class="cart-badge"><?= $cart_count ?></span>
                <?php endif; ?>
            </a>
        </div>
    </div>
</nav>

<!-- SIDEBAR MENU (Offcanvas) -->
<div class="offcanvas offcanvas-start" tabindex="-1" id="sidebarMenu" aria-labelledby="sidebarMenuLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="sidebarMenuLabel">Menu</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <nav class="sidebar-nav">
            <!-- 1. Home -->
            <a href="index.php" class="sidebar-link">Home</a>
            
            <!-- 2. Shop Now -->
            <a href="index.php" class="sidebar-link">Shop Now</a>
            
            <!-- 3. Contact Us (Scrolls to footer) -->
            <!-- Ensure your footer has an id="footer" or simply scrolls to bottom -->
            <a href="#footer" class="sidebar-link" onclick="window.scrollTo({ top: document.body.scrollHeight, behavior: 'smooth' });" data-bs-dismiss="offcanvas">Contact Us</a>
        </nav>
    </div>
</div>