</main>
<footer class="mt-5" style="background-color: <?= $bg_color ?? '#2d2d2d' ?>; color: #ffffff; padding-top: 60px;">

    <style>
        /* General Footer Text */
        .footer-title {
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 25px;
            color: #ffffff;
            font-size: 1.1rem;
        }

        .footer-text, .footer-link {
            color: rgba(255, 255, 255, 0.85);
            font-size: 0.95rem;
            text-decoration: none;
            line-height: 2; /* increased line height for the list look */
            display: block;
            transition: 0.3s;
        }

        .footer-link:hover {
            color: #ffffff;
            padding-left: 5px; /* Subtle movement on hover */
        }

        /* The Vertical Dividers (Key Feature of your image) */
        .footer-column {
            position: relative;
        }

        /* Add vertical line after columns on large screens */
        @media (min-width: 992px) {
            .footer-column::after {
                content: '';
                position: absolute;
                right: 0;
                top: 10%;
                height: 80%;
                width: 1px;
                background-color: rgba(255,255,255,0.2);
            }
            /* Remove the line from the last column */
            .footer-column:last-child::after {
                display: none;
            }
        }

        /* Mobile Adjustments */
        @media (max-width: 991px) {
            .footer-column {
                margin-bottom: 30px;
                text-align: center; /* Center align on mobile */
                border-bottom: 1px solid rgba(255,255,255,0.1); /* Horizontal lines on mobile instead */
                padding-bottom: 20px;
            }
            .footer-column:last-child {
                border-bottom: none;
            }
            .footer-column::after {
                display: none; 
            }
        }

        /* Social Icons */
        .social-icon-wrapper {
            display: flex;
            gap: 15px;
            align-items: center;
        }
        
        /* Adjust alignment based on screen size */
        @media (max-width: 991px) {
            .social-icon-wrapper {
                justify-content: center;
            }
        }

        .social-btn {
            display: inline-flex;
            justify-content: center;
            align-items: center;
            width: 45px;
            height: 45px;
            background: <?= $bg_color ?? '#000' ?>; /* Icon background matches theme or black */
            color: #fff; /* Icon color */
            border-radius: 50%; /* Circle */
            transition: 0.3s;
            text-decoration: none;
            font-size: 1.2rem;
        }
        
        /* Specific brand colors on hover (Optional, or keep white) */
        .social-btn.fb { background-color: #3b5998; }
        .social-btn.ig { background: linear-gradient(45deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%); }
        .social-btn.tw { background-color: #1da1f2; }
        .social-btn.li { background-color: #0077b5; }

        .social-btn:hover {
            transform: translateY(-3px);
            color: #fff;
            filter: brightness(1.2);
        }

        /* Top and Bottom Borders */
        .footer-top-border {
            border-top: 1px solid rgba(255,255,255,0.2);
            margin-bottom: 40px;
        }
        
        .footer-bottom-border {
            border-top: 1px solid rgba(255,255,255,0.2);
            margin-top: 40px;
            padding-top: 20px;
            padding-bottom: 20px;
        }
    </style>

    <div class="container">
        
        <div class="footer-top-border"></div>

        <div class="row">
            
            <div class="col-lg-3 col-md-6 footer-column">
                <h6 class="footer-title">PRODUCTS</h6>
                <div class="d-flex flex-column">
                    <a href="#" class="footer-link">&bull; New Arrivals</a>
                    <a href="#" class="footer-link">&bull; Best Sellers</a>
                    <a href="#" class="footer-link">&bull; Electronics</a>
                    <a href="#" class="footer-link">&bull; Fashion</a>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 footer-column">
                <h6 class="footer-title">QUICK LINKS</h6>
                <div class="d-flex flex-column">
                    <a href="#" class="footer-link">&bull; About Us</a>
                    <a href="#" class="footer-link">&bull; Contact Us</a>
                    <a href="#" class="footer-link">&bull; Login / Register</a>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 footer-column">
                <h6 class="footer-title">CONTACT</h6>
                <div class="d-flex flex-column">
                    <p class="footer-text mb-1"><i class="fas fa-map-marker-alt me-2"></i> Dhaka, Bangladesh</p>
                    <p class="footer-text mb-1"><i class="fas fa-envelope me-2"></i> quencarry2015@gmail.com</p>
                    <p class="footer-text mb-1"><i class="fas fa-phone-alt me-2"></i> +880 1312629624</p>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 footer-column">
                <h6 class="footer-title">FOLLOW US</h6>
                <div class="social-icon-wrapper">
                    <a href="#" class="social-btn fb"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="social-btn ig"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="social-btn tw"><i class="fab fa-twitter"></i></a>
                    <a href="#" class="social-btn li"><i class="fab fa-linkedin-in"></i></a>
                </div>
            </div>

        </div>

        <div class="row">
            <div class="col-12 text-center">
                <div class="footer-bottom-border">
                    <p class="mb-1 text-white-50">
                        © <?= date('Y') ?> <strong>QUEENCARRY</strong>. All Rights Reserved
                    </p>
                    <p class="mb-0 text-white">
                        Developed by <a href="https://brainbloom.fun" target="_blank" style="color: #fff; font-weight: bold; text-decoration: none;">BrainBloom</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>