<?php
// login/login.php
session_start();
require_once '../config/db.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];

    // Check user in database
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user) {
        // Verify Password
        if (password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['full_name'];
            $_SESSION['user_role'] = $user['role'];

            // Redirect based on role
            if ($user['role'] == 'admin') {
                header("Location: ../admin/orders.php");
            } else {
                header("Location: ../product/index.php");
            }
            exit;
        } else {
            $error = "Invalid password.";
        }
    } else {
        $error = "No account found with that email.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0">
    <title>Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        body { 
            background-color: #f0f2f5; 
            min-height: 100vh;
            display: flex; 
            align-items: center; 
            justify-content: center; 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 20px;
        }

        .login-card { 
            width: 100%; 
            max-width: 420px; 
            padding: 2.5rem; 
            background: white; 
            border-radius: 20px; 
            box-shadow: 0 10px 30px rgba(0,0,0,0.08); 
            border: 1px solid rgba(0,0,0,0.02);
        }

        .brand-title {
            font-weight: 800;
            letter-spacing: 1px;
            color: #2d2d2d;
            margin-bottom: 0.5rem;
        }

        .form-label {
            font-size: 0.85rem;
            font-weight: 600;
            color: #666;
            margin-bottom: 8px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        /* Mobile Optimization for Inputs: Prevent Zoom on iOS */
        .form-control {
            background-color: #f8f9fa;
            border: 2px solid #eee;
            border-radius: 12px;
            padding: 14px 15px;
            font-size: 16px; /* Crucial for iOS to prevent zoom */
            transition: all 0.3s ease;
            color: #333;
        }

        .form-control:focus {
            background-color: #fff;
            border-color: #2d2d2d;
            box-shadow: 0 0 0 4px rgba(45, 45, 45, 0.1);
        }

        .btn-primary { 
            background-color: #2d2d2d; 
            border: none; 
            padding: 14px;
            border-radius: 12px;
            font-weight: 700;
            letter-spacing: 0.5px;
            font-size: 1rem;
            transition: transform 0.2s;
        }

        .btn-primary:active {
            transform: scale(0.98);
        }

        .btn-primary:hover { 
            background-color: #000; 
        }

        .back-link {
            color: #888;
            font-size: 0.9rem;
            padding: 10px;
            display: inline-block;
            transition: color 0.3s;
        }
        
        .back-link:hover {
            color: #2d2d2d;
        }

        /* Mobile Specific Adjustments */
        @media (max-width: 576px) {
            body {
                background-color: #fff; /* Seamless white on mobile */
                padding: 0;
            }
            .login-card {
                box-shadow: none;
                border: none;
                border-radius: 0;
                padding: 2rem;
                height: 100vh;
                display: flex;
                flex-direction: column;
                justify-content: center;
            }
            .brand-title {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>

<div class="login-card">
    <div class="text-center mb-5">
        <div class="brand-title">WELCOME BACK</div>
        <p class="text-muted small">Please enter your details to sign in.</p>
    </div>
    
    <?php if($error): ?>
        <div class="alert alert-danger rounded-3 border-0 d-flex align-items-center mb-4">
            <i class="fas fa-exclamation-circle me-2"></i> <?= $error ?>
        </div>
    <?php endif; ?>

    <form method="POST">
        <div class="mb-4">
            <label class="form-label">Email Address</label>
            <div class="input-group">
                <span class="input-group-text bg-light border-0 rounded-start-3 ps-3" style="border: 2px solid #eee; border-right: none;">
                    <i class="fas fa-envelope text-muted"></i>
                </span>
                <input type="email" name="email" class="form-control border-start-0" required placeholder="" style="border-left: none;">
            </div>
        </div>
        
        <div class="mb-5">
            <label class="form-label">Password</label>
            <div class="input-group">
                <span class="input-group-text bg-light border-0 rounded-start-3 ps-3" style="border: 2px solid #eee; border-right: none;">
                    <i class="fas fa-lock text-muted"></i>
                </span>
                <input type="password" name="password" class="form-control border-start-0" required placeholder="" style="border-left: none;">
            </div>
        </div>
        
        <button type="submit" class="btn btn-primary w-100 shadow-sm">
            SIGN IN &nbsp; <i class="fas fa-arrow-right"></i>
        </button>
    </form>
    
    <div class="text-center mt-5">
        <a href="../product/index.php" class="back-link text-decoration-none">
            <i class="fas fa-arrow-left me-1"></i> Back to Store
        </a>
    </div>
</div>

<script>
    // Optional: Auto-focus visual fix for mobile
    const inputs = document.querySelectorAll('.form-control');
    inputs.forEach(input => {
        input.addEventListener('focus', () => {
            input.previousElementSibling.style.borderColor = '#2d2d2d';
            input.previousElementSibling.style.backgroundColor = '#fff';
            input.style.borderColor = '#2d2d2d';
        });
        input.addEventListener('blur', () => {
            input.previousElementSibling.style.borderColor = '#eee';
            input.previousElementSibling.style.backgroundColor = '#f8f9fa';
            input.style.borderColor = '#eee';
        });
    });
</script>

</body>
</html>