<?php
// admin/includes/header.php
require_once __DIR__ . '/../../config/db.php';

// Helper function for image uploads
function uploadImage($file, $targetDir = '../uploads/') {
    if (isset($file) && $file['error'] == 0) {
        if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);
        $fileName = time() . '_' . basename($file['name']);
        $targetFile = $targetDir . $fileName;
        if (move_uploaded_file($file['tmp_name'], $targetFile)) {
            return 'uploads/' . $fileName; // Return path for DB
        }
    }
    return null;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel</title>
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { 
            background-color: #f4f6f9; 
            overflow-x: hidden; 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        /* --- Wrapper & Sidebar Layout --- */
        #wrapper {
            display: flex;
            width: 100%;
            align-items: stretch;
            transition: all 0.3s;
        }
        
        #sidebar-wrapper {
            min-height: 100vh;
            margin-left: -260px; /* Hidden by default on Mobile */
            width: 260px;
            background: #212529;
            color: #fff;
            transition: margin 0.3s ease-out;
            position: fixed;
            z-index: 1000;
            top: 0;
            bottom: 0;
            left: 0;
            box-shadow: 4px 0 10px rgba(0,0,0,0.1);
        }
        
        #sidebar-wrapper .sidebar-heading {
            padding: 1.2rem 1.5rem;
            font-size: 1.25rem;
            font-weight: 700;
            background: #000;
            color: #fff;
            letter-spacing: 1px;
            border-bottom: 1px solid #333;
        }
        
        #sidebar-wrapper .list-group {
            width: 260px;
        }
        
        #sidebar-wrapper .nav-link {
            color: #adb5bd;
            padding: 15px 25px;
            font-size: 1rem;
            border-left: 4px solid transparent;
            transition: all 0.2s;
        }
        
        #sidebar-wrapper .nav-link:hover, 
        #sidebar-wrapper .nav-link.active {
            background-color: #2c3034;
            color: #fff;
            border-left-color: #0d6efd;
        }
        
        #sidebar-wrapper .nav-link i {
            width: 25px;
            text-align: center;
        }

        /* --- Page Content --- */
        #page-content-wrapper {
            width: 100%;
            margin-left: 0;
            transition: margin 0.3s ease-out;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        /* Desktop State (Sidebar Visible) */
        @media (min-width: 768px) {
            #sidebar-wrapper { margin-left: 0; }
            #page-content-wrapper { margin-left: 260px; width: calc(100% - 260px); }
            
            /* Toggled State on Desktop (Hidden) */
            body.toggled #sidebar-wrapper { margin-left: -260px; }
            body.toggled #page-content-wrapper { margin-left: 0; width: 100%; }
        }

        /* Mobile State */
        @media (max-width: 767px) {
            /* Toggled State on Mobile (Visible) */
            body.toggled #sidebar-wrapper { margin-left: 0; }
            body.toggled #page-content-wrapper { margin-left: 0; } 
            /* Optional: Add overlay for mobile when toggled if desired */
        }

        /* --- Header Styles --- */
        .navbar-admin {
            padding: 15px 20px;
            background: #fff;
            box-shadow: 0 2px 15px rgba(0,0,0,0.04);
            border-bottom: 1px solid #edf2f9;
        }
        
        /* Toggle Button */
        #menu-toggle {
            cursor: pointer;
            background: transparent;
            border: 1px solid #dee2e6;
            padding: 6px 12px;
            border-radius: 5px;
            color: #333;
            transition: all 0.2s;
        }
        #menu-toggle:hover { background: #f8f9fa; }

        .card { 
            border: none; 
            border-radius: 10px; 
            box-shadow: 0 5px 20px rgba(0,0,0,0.03); 
            margin-bottom: 25px;
        }
        .card-header {
            background: #fff;
            border-bottom: 1px solid #eee;
            padding: 15px 20px;
            font-weight: 600;
        }
    </style>
</head>
<body>

<div id="wrapper">
    <!-- Sidebar -->
    <div id="sidebar-wrapper">
        <div class="sidebar-heading">ADMIN PANEL</div>
        <div class="list-group list-group-flush mt-3">
            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'orders.php' ? 'active' : ''; ?>" href="orders.php">
                <i class="fas fa-shopping-cart me-2"></i> Orders
            </a>
            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'add_product.php' ? 'active' : ''; ?>" href="add_product.php">
                <i class="fas fa-plus-circle me-2"></i> Add Product
            </a>
            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'slider_images.php' ? 'active' : ''; ?>" href="slider_images.php">
                <i class="fas fa-images me-2"></i> Sliders
            </a>
            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'settings.php' ? 'active' : ''; ?>" href="settings.php">
                <i class="fas fa-cog me-2"></i> Settings
            </a>
            <hr class="text-white-50 mx-3">
            <a class="nav-link text-danger" href="../login/logout.php">
                <i class="fas fa-sign-out-alt me-2"></i> Logout
            </a>
        </div>
    </div>
    <!-- /#sidebar-wrapper -->

    <!-- Page Content -->
    <div id="page-content-wrapper">
        <nav class="navbar navbar-expand-lg navbar-admin">
            <div class="container-fluid">
                <!-- Toggle Button (Left) -->
                <button id="menu-toggle" title="Toggle Sidebar">
                    <i class="fas fa-bars"></i>
                </button>

                <!-- Brand Name (Right) -->
                <div class="ms-auto d-flex align-items-center">
                    <a class="navbar-brand fw-bold text-dark m-0" href="#">MY SHOP ADMIN</a>
                    <a href="../index.php" target="_blank" class="btn btn-sm btn-outline-primary ms-3">
                        <i class="fas fa-external-link-alt"></i> Site
                    </a>
                </div>
            </div>
        </nav>

        <div class="container-fluid px-4 py-4">
            <!-- Content Injected Here -->

<script>
    // Sidebar Toggle Script
    document.addEventListener('DOMContentLoaded', function() {
        var menuToggle = document.getElementById('menu-toggle');
        if (menuToggle) {
            menuToggle.addEventListener('click', function(e) {
                e.preventDefault();
                document.body.classList.toggle('toggled');
            });
        }
    });
</script>