<?php
include 'includes/header.php';

$id = $_GET['id'] ?? null;
if (!$id) die("Product ID missing");

$product = $pdo->prepare("SELECT * FROM products WHERE id = ?");
$product->execute([$id]);
$item = $product->fetch();

if (!$item) die("Product not found");

// Update Logic
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $category_id = $_POST['category_id'];
    $price = $_POST['price'];
    $stock = $_POST['stock_quantity'];
    $desc = $_POST['description'];
    
    // Default to existing image
    $imagePath = $item['image']; 
    if (!empty($_FILES['image']['name'])) {
        $uploaded = uploadImage($_FILES['image']);
        if ($uploaded) $imagePath = $uploaded;
    }

    $sql = "UPDATE products SET name=?, category_id=?, price=?, stock_quantity=?, description=?, image=? WHERE id=?";
    $stmt = $pdo->prepare($sql);
    if ($stmt->execute([$name, $category_id, $price, $stock, $desc, $imagePath, $id])) {
        echo "<script>alert('Product updated!'); window.location.href='edit_product.php?id=$id';</script>";
    }
}

$cats = $pdo->query("SELECT * FROM categories")->fetchAll();
?>

<!-- Page Heading -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold text-dark mb-1">Edit Product</h2>
        <p class="text-muted mb-0">Updating: <span class="fw-bold text-dark"><?= htmlspecialchars($item['name']) ?></span></p>
    </div>
    <a href="add_product.php" class="btn btn-outline-secondary btn-sm">
        <i class="fas fa-arrow-left me-2"></i> Back to List
    </a>
</div>

<form method="POST" enctype="multipart/form-data">
    <div class="row g-4">
        <!-- Product Details Column -->
        <div class="col-lg-8">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header bg-white py-3 fw-bold border-bottom">
                    <i class="fas fa-info-circle text-primary me-2"></i> Product Information
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8 mb-3">
                            <label class="form-label fw-bold small text-uppercase text-muted">Product Name</label>
                            <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($item['name']) ?>" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label fw-bold small text-uppercase text-muted">Category</label>
                            <select name="category_id" class="form-select" required>
                                <?php foreach($cats as $cat): ?>
                                    <option value="<?= $cat['id'] ?>" <?= $cat['id'] == $item['category_id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($cat['name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold small text-uppercase text-muted">Price ($)</label>
                            <div class="input-group">
                                <span class="input-group-text">$</span>
                                <input type="number" step="0.01" name="price" class="form-control" value="<?= $item['price'] ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold small text-uppercase text-muted">Stock Quantity</label>
                            <input type="number" name="stock_quantity" class="form-control" value="<?= $item['stock_quantity'] ?>">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold small text-uppercase text-muted">Description</label>
                        <textarea name="description" class="form-control" rows="5"><?= htmlspecialchars($item['description']) ?></textarea>
                    </div>
                </div>
            </div>
        </div>

        <!-- Product Media Column -->
        <div class="col-lg-4">
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-header bg-white py-3 fw-bold border-bottom">
                    <i class="fas fa-image text-primary me-2"></i> Product Media
                </div>
                <div class="card-body text-center">
                    <label class="form-label fw-bold small text-uppercase text-muted d-block mb-3">Current Image</label>
                    
                    <div class="border rounded bg-light p-3 mb-3 d-flex align-items-center justify-content-center" style="min-height: 200px;">
                        <img src="../<?= $item['image'] ?>" class="img-fluid rounded shadow-sm" style="max-height: 180px;">
                    </div>

                    <label class="btn btn-outline-primary btn-sm w-100">
                        <i class="fas fa-upload me-2"></i> Change Image
                        <input type="file" name="image" class="d-none">
                    </label>
                    <div class="form-text small mt-2">Leave empty to keep current image.</div>
                </div>
            </div>

            <!-- Action Card -->
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-warning fw-bold text-dark py-2">
                            <i class="fas fa-save me-2"></i> Update Product
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<!-- Closing divs matching the opening structure in header.php -->
</div></div></div>
</body>
</html>